@echo off
if "%OS%" == "Windows_NT" setlocal
rem ------------------------------------------------------
rem Start script for the Network Data Model Editor
rem Environment Variable Prerequisites
rem
rem   ORACLE_HOME     Oracle database installation home.
rem ------------------------------------------------------

if not "%ORACLE_HOME%" =="" goto gotHome
echo The ORACLE_HOME environment variable is not defined.
echo This environment variable is needed to run this program.
goto end

:gotHome
if exist "%ORACLE_HOME%\lib\xmlparserv2.jar" goto moreCheck
echo Can't find xmlparserv2.jar.
echo This file is needed to run this program.
goto end

:moreCheck
if exist "%ORACLE_HOME%\jdbc\lib\ojdbc5.jar" goto yetAnotherCheck
echo Can't find ojdbc5.jar.
echo This file is needed to run this program.
goto end

:yetAnotherCheck
if exist "%ORACLE_HOME%\jdk\bin\java" goto doneCheck
echo Can't find java interpreter.
echo Java interpreter is needed to run this program.
goto end


:doneCheck
set JARS=.;%ORACLE_HOME%\lib\xmlparserv2.jar
set JARS=%JARS%;%ORACLE_HOME%\jdbc\lib\classes12.jar

rem Set locations of required jar files as appropriate.

set JARS=%JARS%;%ORACLE_HOME%\md\lib\sdoapi.jar
set JARS=%JARS%;%ORACLE_HOME%\md\lib\sdoutl.jar
set JARS=%JARS%;%ORACLE_HOME%\md\lib\sdotype.jar

set JAVA_PARAMS=-Xms256M -Xmx256M
set EDITOR_CLASS=SDOToKMZ
set PROG_ARGS=-host stadb28.us.oracle.com -sid sdom -port 15215 -driver thin -user scott -password tiger -logofile telelogo.png -files_path /scratch/rkothuri/view_storage/rkothuri_venkatm_sdo/sdo/demo/KMZ/examples/

@echo on

%ORACLE_HOME%\jdk\bin\java %JAVA_PARAMS% -cp %JARS% %EDITOR_CLASS% %PROG_ARGS%


:end

